import { Component, Inject, ViewEncapsulation, ViewChild } from '@angular/core';
import { extend } from '@syncfusion/ej2-base';
import { KanbanComponent, CardSettingsModel, KanbanModule } from '@syncfusion/ej2-angular-kanban';
import { kanbanPizzaData } from './data';
import { NgClass,CommonModule } from '@angular/common';

@Component({
  selector: 'app-root',
  templateUrl: 'app.component.html',
  styleUrls: ['app.component.css'],
  encapsulation: ViewEncapsulation.None,
  standalone: true,
  imports: [ KanbanModule,   NgClass,CommonModule]
})
export class AppComponent {
  @ViewChild('kanbanObj') kanbanObj?: KanbanComponent;
  public kanbanData: Object[] = kanbanPizzaData;
  public cardSettings: CardSettingsModel = {
    headerField: 'Id',
    contentField: 'Description',
  };
  public orderColumns: string[] = ['Ready to Serve', 'Ready to Deliver'];
  public serveColumns: string[] = ['Served'];
  public deliverColumns: string[] = ['Delivered'];
  constructor() {
    
  }
}
